/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.hud;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.config.ConfigDefaults;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;

public class HUDRenderHelper {
    private static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

    public static void drawStringAtPosition(MainWindow window, MatrixStack matrix, ITextComponent text, int lineOffset) {
        int windowScaleHeight = window.func_198087_p();
        int windowScaleWidth = window.func_198107_o();
        ConfigDefaults.HUDPosition position = (ConfigDefaults.HUDPosition)((Object)SimplyJetpacksConfig.hudTextPosition.get());
        int color = (Integer)SimplyJetpacksConfig.hudTextColor.get();
        int xOffset = (Integer)SimplyJetpacksConfig.hudXOffset.get();
        int yOffset = (Integer)SimplyJetpacksConfig.hudYOffset.get();
        long hudScale = (Long)SimplyJetpacksConfig.hudScale.get();
        boolean hudTextShadow = (Boolean)SimplyJetpacksConfig.hudTextShadow.get();
        int screenHeight = (int)((long)windowScaleHeight / hudScale);
        int screenWidth = (int)((long)windowScaleWidth / hudScale);
        switch (position) {
            case TOP_LEFT: {
                HUDRenderHelper.drawStringLeft(matrix, text, 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case TOP_CENTER: {
                HUDRenderHelper.drawStringCenter(matrix, text, screenWidth / 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case TOP_RIGHT: {
                HUDRenderHelper.drawStringRight(matrix, text, screenWidth - 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case LEFT: {
                HUDRenderHelper.drawStringLeft(matrix, text, 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case RIGHT: {
                HUDRenderHelper.drawStringRight(matrix, text, screenWidth - 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case BOTTOM_LEFT: {
                HUDRenderHelper.drawStringLeft(matrix, text, 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, hudTextShadow);
                break;
            }
            case BOTTOM_RIGHT: {
                HUDRenderHelper.drawStringRight(matrix, text, screenWidth - 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, hudTextShadow);
                break;
            }
            default: {
                SimplyJetpacks.LOGGER.info("Invalid HUD Position passed to renderer.");
            }
        }
    }

    private static void drawStringLeft(MatrixStack matrix, ITextComponent text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            fontRenderer.func_243246_a(matrix, text, (float)x, (float)y, color);
        } else {
            fontRenderer.func_243248_b(matrix, text, (float)x, (float)y, color);
        }
    }

    private static void drawStringCenter(MatrixStack matrix, ITextComponent text, int x, int y, int color, boolean shadow) {
        float textWidth = fontRenderer.func_238414_a_((ITextProperties)text);
        if (shadow) {
            fontRenderer.func_243246_a(matrix, text, (float)x - textWidth / 2.0f, (float)y, color);
        } else {
            fontRenderer.func_243248_b(matrix, text, (float)x - textWidth / 2.0f, (float)y, color);
        }
    }

    private static void drawStringRight(MatrixStack matrix, ITextComponent text, int x, int y, int color, boolean shadow) {
        float textWidth = fontRenderer.func_238414_a_((ITextProperties)text);
        if (shadow) {
            fontRenderer.func_243246_a(matrix, text, (float)x - textWidth, (float)y, color);
        } else {
            fontRenderer.func_243248_b(matrix, text, (float)x - textWidth, (float)y, color);
        }
    }
}

